#ifndef _DEVPREVIEW_H_
#define _DEVPREVIEW_H_

#include <Windows.h>
#include "dllexport.h"

class IDevUserLogin;

typedef enum 
{
    STREAM_HIK   = 0x0,
    STREAM_PS    = 0x1,
    STREAM_3GPP  = 0x2
} MOVIE_TYPE;

class IDevPreview
{
public:
    virtual bool SetPlayWnd(HWND) = 0;
    virtual HWND GetPlayWnd() = 0;
    virtual bool StartRealPlay() = 0;
    virtual bool StopRealPlay()  = 0;
    virtual bool CaptureFrame(char *sPicFileName, int picType) = 0;
    virtual bool StartRecording(DWORD dwMovieType, char *sFileName) = 0;
    virtual bool StopRecording() = 0;
    virtual bool GetVideoEffect(DWORD *pBrightValue, DWORD *pContrastValue, DWORD *pSaturationValue, DWORD *pHueValue) = 0;
    virtual bool SetVideoEffect(DWORD dwBrightValue, DWORD dwContrastValue, DWORD dwSaturationValue, DWORD dwHueValue) = 0;
    virtual bool RegisterDrawFun(void *cbDrawFun, DWORD dwUser) = 0;
    virtual bool RegisterRealDataFun(void *cbRealDataFun, DWORD dwUser) = 0;
    virtual bool OpenSound() = 0;
    virtual bool CloseSound() = 0;
    virtual bool SetAudioMode(DWORD dwMode) = 0;
    virtual bool SetVolume(int  nVolume) = 0;
    virtual bool IsVideoPlaying() = 0;
    virtual bool IsSoundOpened() = 0;
    virtual bool IsRecording() = 0;
    virtual bool SetProtocol(int protocol) = 0; // TCP UDP MCAST RTP
    virtual bool SetStream(int num) = 0;  // 0:master 1:second 2:third
	virtual int  GetStream() = 0;
	virtual void GetRealHandle(LONG &lRealHandle) = 0;
};

class DLLAPI CDevPreviewFactory
{
public:
	static IDevPreview *CreateDevPreview(IDevUserLogin *pUser, LONG lChannel);
	static void DeleteDevPreview(IDevPreview *preview, IDevUserLogin *pUsr);
};

#endif
